/*
   This program shows how a Java program can redirect
   its standard input stream (stdin) to a file.

   After this program redirects stdin, it just
   reads lines from stdin and echos them to stdout.

   Be sure to try, and think about, what happens when
   you execute the following cmd.exe command line. Notice
   that in this command line, cmd.exe does an I/O redirection.

   C:\> java RedirectStdinToFile <L100.txt


   Important: Notice how this program is similar to the
   following command line.

   C:\> java Echo < L50.txt

   In the case of the above command line, the shell
   program (cmd.exe) sets up the I/O redirection before
   running the program Echo.class. In the case of this
   program, the program itself does its own I/O redirection.
*/
import java.util.Scanner;
import java.io.*;

public class RedirectStdinToFile
{
   public static void main(String[] args) throws FileNotFoundException
   {
      // Set System.in to be a file (instead of whatever stdin originally was).
      System.setIn( new FileInputStream( "L50.txt" ) );

      // Create a Scanner object to make it easier to use System.in
      Scanner scanner = new Scanner( System.in );

      // Echo every line of input from stdin to stdout.
      while ( scanner.hasNextLine() )
      {
         String oneLine = scanner.nextLine();
         // If you want to, you could manipulate (i.e., filter)
         // the line of input before sending it to stdout.
         System.out.println( oneLine );
      }
   }
}